@php
    $common_settings = session()->get('business.common_settings');
    $multiplier = 1;
    $action = !empty($action) ? $action : '';
    $is_intercompany = request()->boolean('intercompany') || !empty($is_intercompany);
    $force_lot_before_qty = isset($force_lot_before_qty) ? (bool)$force_lot_before_qty : true;

    $tryLoadLotsIfEmpty = function($product) use ($is_intercompany) {
        try {
            if (!empty($product->lot_numbers)) { return $product; }
            if (empty($product->variation_id)) { $product->lot_numbers = []; return $product; }

            $locId = $product->location_id ?? request('location_id');
            $bizId = $product->business_id ?? (auth()->user()->business_id ?? null);

            $base = DB::table('purchase_lines as pl')
                ->leftJoin('purchase_lines as src', function($j){
                    $j->on('src.id', '=', 'pl.parent_purchase_line_id')
                      ->orOn('src.id', '=', 'pl.parent_pl_id')
                      ->orOn('src.id', '=', 'pl.purchase_parent_id');
                })
                ->leftJoin('transactions as t', 't.id', '=', 'pl.transaction_id')
                ->selectRaw("
                    pl.id as purchase_line_id,
                    COALESCE(NULLIF(pl.lot_number,''), NULLIF(src.lot_number,'')) as lot_number,
                    COALESCE(pl.exp_date, src.exp_date) as exp_date,
                    COALESCE(pl.qty_remaining,
                             pl.quantity_remaining,
                             (pl.quantity - COALESCE(pl.quantity_sold,0) - COALESCE(pl.quantity_adjusted,0) + COALESCE(pl.quantity_returned,0)),
                             0
                    ) as qty_available
                ")
                ->where('pl.variation_id', $product->variation_id)
                ->when(!empty($locId), fn($q)=>$q->where('pl.location_id', $locId))
                ->when(!empty($bizId), function($q) use ($bizId){
                    $q->where(function($qq) use ($bizId){
                        $qq->where('t.business_id', $bizId)->orWhereNull('t.business_id');
                    });
                })
                ->where(function($q){
                    $q->whereNotNull('pl.qty_remaining')->where('pl.qty_remaining','>',0)->orWhereNull('pl.qty_remaining');
                })
                ->orderByRaw("COALESCE(pl.exp_date, src.exp_date, '9999-12-31') ASC, pl.id ASC");

            $rows = $base->get();

            if ($rows->count() === 0 && $is_intercompany) {
                $rows = DB::table('purchase_lines as pl')
                    ->leftJoin('purchase_lines as src', function($j){
                        $j->on('src.id', '=', 'pl.parent_purchase_line_id')
                          ->orOn('src.id', '=', 'pl.parent_pl_id')
                          ->orOn('src.id', '=', 'pl.purchase_parent_id');
                    })
                    ->leftJoin('transactions as t', 't.id', '=', 'pl.transaction_id')
                    ->selectRaw("
                        pl.id as purchase_line_id,
                        COALESCE(NULLIF(pl.lot_number,''), NULLIF(src.lot_number,'')) as lot_number,
                        COALESCE(pl.exp_date, src.exp_date) as exp_date,
                        COALESCE(pl.qty_remaining,
                                 pl.quantity_remaining,
                                 (pl.quantity - COALESCE(pl.quantity_sold,0) - COALESCE(pl.quantity_adjusted,0) + COALESCE(pl.quantity_returned,0)),
                                 0
                        ) as qty_available
                    ")
                    ->where('pl.variation_id', $product->variation_id)
                    ->when(!empty($bizId), function($q) use ($bizId){
                        $q->where(function($qq) use ($bizId){
                            $qq->where('t.business_id', $bizId)->orWhereNull('t.business_id');
                        });
                    })
                    ->orderByRaw("COALESCE(pl.exp_date, src.exp_date, '9999-12-31') ASC, pl.id ASC")
                    ->get();
            }

            $product->lot_numbers = $rows->map(function($pl){
                return (object)[
                    'purchase_line_id' => $pl->purchase_line_id,
                    'lot_number'       => $pl->lot_number,
                    'exp_date'         => $pl->exp_date,
                    'qty_available'    => (float)$pl->qty_available,
                ];
            })->all();

        } catch (\Throwable $e) {
            $product->lot_numbers = $product->lot_numbers ?? [];
        }
        return $product;
    };
@endphp

@foreach($sub_units as $key => $value)
    @if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key)
        @php $multiplier = max(1, (float)$value['multiplier']); @endphp
    @endif
@endforeach

<tr class="product_row"
    data-row_index="{{$row_count}}"
    data-existing-line="{{ !empty($product->transaction_sell_lines_id) ? 1 : 0 }}"
    data-qty_available="{{ $max_quantity }}"
    @if(!empty($so_line)) data-so_id="{{$so_line->transaction_id}}" @endif>
    <td>
        @if(!empty($so_line))
            <input type="hidden" name="products[{{$row_count}}][so_line_id]" value="{{$so_line->id}}">
        @endif

        @php
            $product_name = $product->product_name . '<br/>' . $product->sub_sku ;
            if(!empty($product->brand)){ $product_name .= ' ' . e($product->brand) ;}
        @endphp

        @if( ($edit_price || $edit_discount) && empty($is_direct_sell) )
            <div title="@lang('lang_v1.pos_edit_product_price_help')" style="display: inline">
                <span class="text-link text-info cursor-pointer" data-toggle="modal" data-target="#row_edit_product_price_modal_{{$row_count}}">{!! $product_name !!}&nbsp;<i class="fa fa-info-circle"></i></span>
            </div>
        @else
            {!! $product_name !!}
        @endif

        <img src="@if(count($product->media) > 0)
                        {{$product->media->first()->display_url}}
                    @elseif(!empty($product->product_image))
                        {{asset('/uploads/img/' . rawurlencode($product->product_image))}}
                    @else
                        {{asset('/img/default.png')}}
                    @endif"
             alt="product-img" loading="lazy" decoding="async" referrerpolicy="no-referrer"
             style="height: 100%;display: inline;margin-left: 3px; border: black;border-radius: 5px; margin-top: 5px; width: 50px;object-fit: cover;">

        <input type="hidden" class="enable_sr_no" value="{{$product->enable_sr_no}}">
        <input type="hidden" class="product_type" name="products[{{$row_count}}][product_type]" value="{{$product->product_type}}">

        @php
            $hide_tax = session()->get('business.enable_inline_tax') == 1 ? '' : 'hide';
            $tax_id = $product->tax_id;
            $item_tax = !empty($product->item_tax) ? $product->item_tax : 0;
            $unit_price_inc_tax = $product->sell_price_inc_tax;

            if($hide_tax == 'hide'){ $tax_id = null; $unit_price_inc_tax = $product->default_sell_price; }
            if(!empty($so_line) && $action !== 'edit') {
                $tax_id = $so_line->tax_id; $item_tax = $so_line->item_tax; $unit_price_inc_tax = $so_line->unit_price_inc_tax;
            }

            $discount_type = !empty($product->line_discount_type) ? $product->line_discount_type : 'fixed';
            $discount_amount = !empty($product->line_discount_amount) ? $product->line_discount_amount : 0;
            if(!empty($discount)) { $discount_type = $discount->discount_type; $discount_amount = $discount->discount_amount; }
            if(!empty($so_line) && $action !== 'edit') { $discount_type = $so_line->line_discount_type; $discount_amount = $so_line->line_discount_amount; }

            $sell_line_note = !empty($product->sell_line_note) ? $product->sell_line_note : (!empty($so_line) ? $so_line->sell_line_note : '');

            $unit_label = $product->unit ?? '';
            if (!empty($sub_units[$product->sub_unit_id]['name'] ?? null)) { $unit_label = $sub_units[$product->sub_unit_id]['name']; }
        @endphp

        @if(!empty($discount))
            {!! Form::hidden("products[$row_count][discount_id]", $discount->id); !!}
        @endif

        @php
            $warranty_id = !empty($action) && $action == 'edit' && !empty($product->warranties->first())  ? $product->warranties->first()->id : $product->warranty_id;
            if($discount_type == 'fixed') { $discount_amount = $discount_amount * $multiplier; }
        @endphp

        @if(empty($is_direct_sell))
        <div class="modal fade row_edit_product_price_model" id="row_edit_product_price_modal_{{$row_count}}" tabindex="-1" role="dialog">
            @include('sale_pos.partials.row_edit_product_price_modal')
        </div>
        @endif

        <br>
        @php
            $header_qty = (float)($product->qty_available ?? 0);
            $header_qty_in_selected = $header_qty / max(1, (float)$multiplier);
        @endphp
        <small class="text-muted p-1">
            @if($product->enable_stock)
                @if(isset($obj) && $refererPath!='/pos/create')
                    {{ round($header_qty_in_selected) }} {{$unit_label}} @lang('lang_v1.in_stock')
                @else
                    {{ @num_format($header_qty_in_selected) }} {{$unit_label}} @lang('lang_v1.in_stock')
                @endif
            @else
                --
            @endif
        </small>

        @if(in_array('modifiers' , $enabled_modules))
            <div class="modifiers_html">
                @if(!empty($product->product_ms))
                    @include('restaurant.product_modifier_set.modifier_for_product', ['edit_modifiers' => true, 'row_count' => $loop->index, 'product_ms' => $product->product_ms])
                @endif
            </div>
        @endif

        @php
            $max_quantity_base = (float)($product->qty_available ?? 0);
            $max_quantity = $max_quantity_base / max(1, (float)$multiplier);

            if (!empty($action) && $action == 'edit') {
                if (!empty($so_line)) {
                    $qty_avl_edit = ($so_line->quantity - $so_line->so_quantity_invoiced + $product->quantity_ordered);
                    $max_quantity = (float)$qty_avl_edit / max(1, (float)$multiplier);
                }
            } else {
                if (!empty($so_line) && $so_line->qty_available <= $max_quantity_base) {
                    $max_quantity = (float)$so_line->qty_available / max(1, (float)$multiplier);
                }
            }

            $formatted_header_qty_in_selected = app('App\Utils\Util')->num_f($max_quantity);
            $max_qty_rule = $max_quantity;
            $max_qty_msg  = __('validation.custom-messages.quantity_not_available', ['qty'=> $formatted_header_qty_in_selected, 'unit' => $unit_label]);
        @endphp

        {{-- LOT & EXPIRY --}}
        @php $product = $tryLoadLotsIfEmpty($product); @endphp

        @php
            $lot_enabled   = session()->get('business.enable_lot_number') == 1;
            $exp_enabled   = session()->get('business.enable_product_expiry') == 1;
            $lot_dropdown_should_show = ($lot_enabled || $exp_enabled) && !empty($product->lot_numbers) && (empty($is_sales_order) || $is_intercompany);
        @endphp

        @php
            // Never lock the lot dropdown for existing lines on edit; user should see and change if needed.
            $lock_lot_dropdown = false;
        @endphp
        @if($lot_dropdown_should_show)
            <input type="hidden" class="lot-dropdown-present" value="1">
            <select class="form-control lot_number input-sm"
                    name="products[{{$row_count}}][lot_no_line_id]"
                    @if($lock_lot_dropdown) disabled @endif
                    required
                    data-rule-required="true"
                    data-msg-required="{{ __('Please select Lot & Expiry') }}">
                <option value="">@lang('lang_v1.lot_n_expiry')</option>

                @php
                    $header_qty_in_selected = (float) (($product->qty_available ?? 0) / max(1, (float)$multiplier));
                    $unit_label = $product->unit ?? '';
                    if (!empty($sub_units[$product->sub_unit_id]['name'] ?? null)) { $unit_label = $sub_units[$product->sub_unit_id]['name']; }
                    $allow_decimal = !empty($product->unit_allow_decimal) && $product->unit_allow_decimal == 1;
                @endphp

                @foreach($product->lot_numbers as $lot_number)
                    @php
                        $selected = "";
                        $lot_base = max(0, (float)($lot_number->qty_available ?? 0));
                        $lot_sell = $lot_base / max(1, (float)$multiplier);

                        if ($header_qty_in_selected > 0 && $lot_sell > $header_qty_in_selected) {
                            $lot_sell = $header_qty_in_selected;
                        }

                        $lot_rule_qty = $allow_decimal ? $lot_sell : floor($lot_sell);
                        $lot_disp_qty = $allow_decimal
                            ? app('App\Utils\Util')->num_f($lot_sell)
                            : app('App\Utils\Util')->num_f($lot_rule_qty);

                        if(($lot_number->purchase_line_id ?? null) == ($product->lot_no_line_id ?? null)){
                            $selected     = "selected";
                            $max_qty_rule = $lot_rule_qty;
                            $max_qty_msg  = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_disp_qty, 'unit' => $unit_label]);
                        }

                        $expiry_text = '';
                        if($exp_enabled && !empty($lot_number->exp_date)){
                            try {
                                $is_expired = \Carbon\Carbon::now()->gt(\Carbon\Carbon::createFromFormat('Y-m-d', substr($lot_number->exp_date,0,10)));
                                if($is_expired){ $expiry_text = '(' . __('report.expired') . ')'; }
                            } catch (\Throwable $e) {}
                        }

                        if(!empty($purchase_line_id) && $purchase_line_id == ($lot_number->purchase_line_id ?? null)) {
                            $selected     = "selected";
                            $max_qty_rule = $lot_rule_qty;
                            $max_qty_msg  = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_disp_qty, 'unit' => $unit_label]);
                        }

                        $label_lot = $lot_number->lot_number ?: 'No lot';
                    @endphp

                    <option
                        value="{{ $lot_number->purchase_line_id ?? '' }}"
                        data-qty_available="{{ (float)($lot_number->qty_available ?? 0) }}"
                        data-msg-max="@lang('lang_v1.quantity_error_msg_in_lot', ['qty'=> $lot_disp_qty, 'unit' => $unit_label])"
                        @if(!empty($lot_number->exp_date))
                            @php $expired = false; try { $expired = \Carbon\Carbon::parse($lot_number->exp_date)->isPast(); } catch(\Throwable $e) {} @endphp
                            @if($expired) disabled title="@lang('report.expired')" @endif
                        @endif
                        {{$selected}}
                    >
                        {{ $label_lot }}
                        @if($lot_enabled && $exp_enabled) - @endif
                        @if($exp_enabled && !empty($lot_number->exp_date))
                            @lang('product.exp_date'): {{ @format_date($lot_number->exp_date) }}
                        @endif
                        {{ $expiry_text }}
                        — {{ $lot_disp_qty }} {{ $unit_label }}
                    </option>
                @endforeach
            </select>
            <div class="text-right">
                <button type="button"
                        class="btn btn-link btn-xs add-another-lot"
                        data-variation-id="{{ $product->variation_id }}"
                        style="padding:0;">
                    <i class="fa fa-plus"></i> @lang('lang_v1.add_another_lot')
                </button>
            </div>
            @if($lock_lot_dropdown)
                <input type="hidden" name="products[{{$row_count}}][lot_no_line_id]" value="{{ $product->lot_no_line_id }}">
            @endif
        @endif

        {{-- Reminder (visible while locked) --}}
        <div class="lot-reminder text-danger" style="display:none;margin-top:4px;">
            <i class="fa fa-exclamation-circle"></i>
            @lang('Please select') @lang('lot & expiry') @lang('first') — @lang('then enter quantity')
        </div>

        @if(isset($obj) && $refererPath!='/pos/create')
            @php $displayed_locations = []; @endphp
            <div class="location-info-container" style="margin-bottom: 10px;">
                <ul class="location-list-header" style="display: flex; list-style: none; padding: 0; margin: 0; border-bottom: 1px solid #ddd; font-weight: bold;">
                    <li style="flex: 3; padding: 5px; border-right: 1px solid #ddd;">Location</li>
                    <li style="flex: 2; padding: 5px; border-right: 1px solid #ddd; text-align: center;">Qty</li>
                    <li style="flex: 2.5; padding: 5px; border-right: 1px solid #ddd; text-align: center;">Lot NO.</li>
                    <li style="flex: 2.5; padding: 5px; text-align: center;">Exp.Date</li>
                </ul>
                @foreach($obj as $location)
                    @if(!in_array($location->name ?? 'unknown', $displayed_locations))
                        @php
                            $displayed_locations[] = $location->name ?? 'unknown';
                            try {
                                $purch_obj = DB::table('purchase_lines')->select('lot_number', 'exp_date')->where('product_id', $location->product_id)->first();
                                $lotNumber = $purch_obj->lot_number ?? 'N/A';
                                $expDate = $purch_obj->exp_date ?? 'N/A';
                            } catch (\Throwable $e) {
                                $lotNumber = 'N/A'; $expDate = 'N/A';
                            }
                            $qtyClass = $location->qty_available > 0 ? 'text-success' : 'text-danger';
                        @endphp
                        <ul class="location-list-row" style="display: flex; list-style: none; padding: 0; margin: 0; border-bottom: 1px solid #ddd; font-size: 12px;">
                            <li style="flex: 3; padding: 5px; border-right: 1px solid #ddd;">{{ $location->name ?? 'Unknown' }} ({{ $location->last_name ?? '' }})</li>
                            <li style="flex: 2; padding: 5px; border-right: 1px solid #ddd; text-align: center;" class="{{ $qtyClass }}">{{ $location->qty_available }}</li>
                            <li style="flex: 2.5; padding: 5px; border-right: 1px solid #ddd; text-align: center;">{{ $lotNumber }}</li>
                            <li style="flex: 2.5; padding: 5px; text-align: center;">{{ $expDate }}</li>
                        </ul>
                    @endif
                @endforeach
            </div>
        @endif
    </td>

    <td>
        @if(!empty($product->transaction_sell_lines_id))
            <input type="hidden" name="products[{{$row_count}}][transaction_sell_lines_id]" class="form-control" value="{{$product->transaction_sell_lines_id}}">
        @endif

        <input type="hidden" name="products[{{$row_count}}][product_id]" class="form-control product_id" value="{{$product->product_id}}">
        <input type="hidden" value="{{$product->variation_id}}" name="products[{{$row_count}}][variation_id]" class="row_variation_id">
        <input type="hidden" value="{{$product->enable_stock}}" name="products[{{$row_count}}][enable_stock]">

        @php $allow_decimal = $product->unit_allow_decimal == 1; @endphp

        @foreach($sub_units as $key => $value)
            @if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key)
                @php
                    $unit_name = $value['name'];
                    $max_qty_msg = __('validation.custom-messages.quantity_not_available', ['qty'=> $max_qty_rule, 'unit' => $unit_name]);
                    if(!empty($product->lot_no_line_id)){
                        $max_qty_msg = __('lang_v1.quantity_error_msg_in_lot', ['qty'=> $max_qty_rule, 'unit' => $unit_name]);
                    }
                    if($value['allow_decimal']) { $allow_decimal = true; }
                @endphp
            @endif
        @endforeach

        @php
            $has_lot_dropdown   = $lot_dropdown_should_show;
            $no_selected_lot    = empty($product->lot_no_line_id) && empty($purchase_line_id);
            $initial_disable    = $force_lot_before_qty && $has_lot_dropdown && $no_selected_lot;
            $is_edit_mode       = isset($action) && $action === 'edit';
            $is_existing_line   = !empty($product->transaction_sell_lines_id);

            // Always show the recorded quantity when editing an existing line so the user can review it.
            if ($is_edit_mode && $is_existing_line) {
                $initial_disable = false;
            } elseif ($is_edit_mode && !$force_lot_before_qty) {
                $initial_disable = false;
            }

            // Original values
            // Prefer recorded ordered qty; fall back to quantity if not populated
            $orig_qty       = (float)($product->quantity_ordered ?? ($product->quantity ?? 1));
            $orig_price_inc = $unit_price_inc_tax;
            $orig_price_ex  = !empty($product->unit_price_before_discount) ? $product->unit_price_before_discount : $product->default_sell_price;
            if(!empty($so_line) && $action !== 'edit') { $orig_price_ex = $so_line->unit_price_before_discount; }
            $orig_disc_amt  = !empty($discount_amount) ? $discount_amount : 0;
            $orig_disc_type = $discount_type;
            $orig_subtotal  = $orig_qty * $orig_price_inc;

            // Always render the saved values; JS will handle locking new rows.
            $init_qty       = $orig_qty;
            $init_min       = 1;
            $init_price_inc = $orig_price_inc;
            $init_price_ex  = $orig_price_ex;
            $init_disc_amt  = $orig_disc_amt;
            $init_subtotal  = $orig_subtotal;
        @endphp

        <div class="input-group input-number">
            <span class="input-group-btn">
                <button type="button" class="btn btn-default btn-flat quantity-down" @if($initial_disable) disabled @endif>
                    <i class="fa fa-minus text-danger"></i>
                </button>
            </span>

            <input type="text"
                   class="form-control pos_quantity input_number mousetrap input_quantity"
                   name="products[{{$row_count}}][quantity]"
                   value="{{ @format_quantity($init_qty) }}"
                   data-min="{{ $init_min }}"
                   data-saved-qty="{{ $orig_qty }}"
                   data-orig="{{ @format_quantity($orig_qty) }}"
                   data-allow-overselling="@if(empty($pos_settings['allow_overselling'])){{'false'}}@else{{'true'}}@endif"
                   @if($allow_decimal) data-decimal="1" @else data-decimal="0" data-rule-abs_digit="true" data-msg-abs_digit="@lang('lang_v1.decimal_value_not_allowed')" @endif
                   data-rule-required="true" data-msg-required="@lang('validation.custom-messages.this_field_is_required')"
                   @if($product->enable_stock && empty($pos_settings['allow_overselling']) && empty($is_sales_order))
                        data-rule-max-value="{{ $max_qty_rule }}"
                        data-qty_available="{{ (float)($product->qty_available ?? 0) }}"
                        data-msg-max-value="{{ $max_qty_msg }}"
                        data-msg_max_default="@lang('validation.custom-messages.quantity_not_available', ['qty'=> $formatted_header_qty_in_selected, 'unit'=> $unit_label])"
                   @endif
                   @if($initial_disable) disabled @endif
            >

            <span class="input-group-btn">
                <button type="button" class="btn btn-default btn-flat quantity-up" @if($initial_disable) disabled @endif>
                    <i class="fa fa-plus text-success"></i>
                </button>
            </span>
        </div>

        {{-- Unit selector --}}
        <input type="hidden" name="products[{{$row_count}}][product_unit_id]" value="{{$product->unit_id}}">
        @if(count($sub_units) > 0)
            <br>
            <select name="products[{{$row_count}}][sub_unit_id]" class="form-control input-sm sub_unit">
                @foreach($sub_units as $key => $value)
                    <option value="{{$key}}" data-multiplier="{{$value['multiplier']}}" data-unit_name="{{$value['name']}}" data-allow_decimal="{{$value['allow_decimal']}}" @if(!empty($product->sub_unit_id) && $product->sub_unit_id == $key) selected @endif>
                        {{$value['name']}}
                    </option>
                @endforeach
           </select>
        @else
            {{$product->unit}}
        @endif

        @if(!empty($product->second_unit))
            <br>
            <span style="white-space: nowrap;">@lang('lang_v1.quantity_in_second_unit', ['unit' => $product->second_unit])*:</span><br>
            <input type="text" name="products[{{$row_count}}][secondary_unit_quantity]" value="{{@format_quantity($product->secondary_unit_quantity)}}" class="form-control input-sm input_number" required>
        @endif

        {{-- hidden helpers --}}
        <input type="hidden" class="base_unit_multiplier" name="products[{{$row_count}}][base_unit_multiplier]" value="{{ max(1, (float)$multiplier) }}">
        <input type="hidden" class="hidden_base_unit_sell_price" value="{{$product->default_sell_price / max(1, (float)$multiplier)}}">

        {{-- Direct-sell unit price (ex-tax) if shown on this row --}}
        @if(!empty($is_direct_sell))
            @php $pos_unit_price = $orig_price_ex; @endphp
            <input type="hidden" class="orig_pos_unit_price" value="{{ @num_format($pos_unit_price) }}">
        @endif
    </td>

    @if(!empty($is_direct_sell))
        @if(!empty($pos_settings['inline_service_staff']))
            <td>
                <div class="form-group">
                    <div class="input-group">
                        {!! Form::select("products[" . $row_count . "][res_service_staff_id]", $waiters, !empty($product->res_service_staff_id) ? $product->res_service_staff_id : null, ['class' => 'form-control select2 order_line_service_staff', 'placeholder' => __('restaurant.select_service_staff'), 'required' => (!empty($pos_settings['is_service_staff_required']) && $pos_settings['is_service_staff_required'] == 1)]) !!}
                    </div>
                </div>
            </td>
        @endif
        @php $pos_unit_price = $orig_price_ex; @endphp
        <td class="@if(!auth()->user()->can('edit_product_price_from_sale_screen')) hide @endif">
            <input type="text"
                   name="products[{{$row_count}}][unit_price]"
                   class="form-control pos_unit_price input_number mousetrap"
                   value="{{ @num_format($init_price_ex) }}"
                   data-orig="{{ @num_format($orig_price_ex) }}"
                   @if($initial_disable) readonly @endif
                   @if(!empty($pos_settings['enable_msp'])) data-rule-min-value="{{$pos_unit_price}}" data-msg-min-value="{{__('lang_v1.minimum_selling_price_error_msg', ['price' => @num_format($pos_unit_price)])}}" @endif>
            @if(!empty($last_sell_line))
                <br><small class="text-muted">@lang('lang_v1.prev_unit_price'): @format_currency($last_sell_line->unit_price_before_discount)</small>
            @endif
        </td>
        <td @if(!$edit_discount) class="hide" @endif>
            {!! Form::text("products[$row_count][line_discount_amount]", @num_format($init_disc_amt), ['class' => 'form-control input_number row_discount_amount','data-orig'=>@num_format($orig_disc_amt),'readonly'=>$initial_disable]) !!}<br>
            {!! Form::select("products[$row_count][line_discount_type]", ['fixed' => __('lang_v1.fixed'), 'percentage' => __('lang_v1.percentage')], $discount_type , ['class' => 'form-control row_discount_type', $initial_disable ? 'disabled' : '']) !!}
            @if(!empty($discount))
                <p class="help-block">{!! __('lang_v1.applied_discount_text', ['discount_name' => $discount->name, 'starts_at' => $discount->formated_starts_at, 'ends_at' => $discount->formated_ends_at]) !!}</p>
            @endif
        </td>
        <td class="text-center {{$hide_tax}}">
            {!! Form::hidden("products[$row_count][item_tax]", @num_format($item_tax), ['class' => 'item_tax']) !!}
            {!! Form::select("products[$row_count][tax_id]", $tax_dropdown['tax_rates'], $tax_id, ['placeholder' => 'Select', 'class' => 'form-control tax_id'], $tax_dropdown['attributes']) !!}
        </td>
    @else
        @if(!empty($pos_settings['inline_service_staff']))
            <td>
                <div class="form-group">
                    <div class="input-group">
                        {!! Form::select("products[" . $row_count . "][res_service_staff_id]", $waiters, !empty($product->res_service_staff_id) ? $product->res_service_staff_id : null, ['class' => 'form-control select2 order_line_service_staff', 'placeholder' => __('restaurant.select_service_staff'), 'required' => (!empty($pos_settings['is_service_staff_required']) && $pos_settings['is_service_staff_required'] == 1)]) !!}
                    </div>
                </div>
            </td>
        @endif
    @endif

    {{-- Unit price (inc tax) --}}
    <td class="{{$hide_tax}}">
        <input type="text"
               name="products[{{$row_count}}][unit_price_inc_tax]"
               class="form-control pos_unit_price_inc_tax input_number"
               value="{{ @num_format($init_price_inc) }}"
               data-orig="{{ @num_format($orig_price_inc) }}"
               @if(!$edit_price || $initial_disable) readonly @endif
               @if(!empty($pos_settings['enable_msp'])) data-rule-min-value="{{$unit_price_inc_tax}}" data-msg-min-value="{{__('lang_v1.minimum_selling_price_error_msg', ['price' => @num_format($unit_price_inc_tax)])}}" @endif>
    </td>

    {{-- Subtotal --}}
    <td class="text-center">
        @php $subtotal_type = !empty($pos_settings['is_pos_subtotal_editable']) ? 'text' : 'hidden'; @endphp
        <input type="{{$subtotal_type}}"
               class="form-control pos_line_total @if(!empty($pos_settings['is_pos_subtotal_editable'])) input_number @endif"
               value="{{ @num_format($init_subtotal) }}"
               data-orig="{{ @num_format($orig_subtotal) }}"
               @if($initial_disable) readonly @endif>
        <span class="display_currency pos_line_total_text @if(!empty($pos_settings['is_pos_subtotal_editable'])) hide @endif"
              data-currency_symbol="true"
              data-orig="{{ @num_format($orig_subtotal) }}"
        >{{ @num_format($init_subtotal) }}</span>
    </td>

    <td class="text-center v-center">
        <i class="fa fa-times text-danger pos_remove_row cursor-pointer" aria-hidden="true"></i>
    </td>
</tr>

<style>
.location-info-container { margin-bottom: 10px; font-size: 12px; }
.location-list-header, .location-list-row { display: flex; list-style: none; padding: 0; margin: 0; border-bottom: 1px solid #ddd; }
.location-list-header { font-weight: bold; background-color: #f9f9f9; }
.location-list-header li, .location-list-row li { padding: 5px; border-right: 1px solid #ddd; }
.location-list-header li:last-child, .location-list-row li:last-child { border-right: none; }
.location-list-header li:nth-child(1), .location-list-row li:nth-child(1) { flex: 3; }
.location-list-header li:nth-child(2), .location-list-row li:nth-child(2) { flex: 2; text-align: center; }
.location-list-header li:nth-child(3), .location-list-row li:nth-child(3) { flex: 2.5; text-align: center; }
.location-list-header li:nth-child(4), .location-list-row li:nth-child(4) { flex: 2.5; text-align: center; }
.text-success { color: #28a745; }
.text-danger { color: #dc3545; }
.lot-locked .input_quantity[disabled],
.lot-locked .pos_unit_price_inc_tax[readonly],
.lot-locked .pos_unit_price[readonly],
.lot-locked .row_discount_amount[readonly] { background: #f9f9f9; }
</style>

<script>
(function ($) {
  function setZeroMoney($el) { if ($el.length) { $el.val('0'); $el.trigger('change'); } }
  function setMoney($el, val) { if ($el.length) { $el.val(val); $el.trigger('change'); } }
  function textToZero($el) { if ($el.length) { $el.text('0.00'); } }
  function textToOrig($el) { if ($el.length) { var v=$el.attr('data-orig'); if(v!==undefined) $el.text(v); } }
  function lotLockRequired($row) {
    if ($row) {
      var existingAttr = $row.attr('data-existing-line');
      var existingData = $row.data('existingLine');
      if (existingAttr === '1' || existingAttr === 1 || existingData === 1 || existingData === '1') {
        return false;
      }
    }
    var attr = $('#pos_table').attr('data-require-lot-before-qty');
    if (typeof attr === 'undefined') { return true; }
    return attr === '1' || attr === 1 || attr === true || attr === 'true';
  }

  // Lock = lot required but not selected: qty must be 0 & disabled.
  // Unlock = lot selected: on the FIRST unlock only, if qty<=0 then set to 1.
  // After first unlock or if user typed a value, never touch qty again.
  function isExistingLine($row) {
    if (!$row) return false;
    var existingAttr = $row.attr('data-existing-line');
    var existingData = $row.data('existingLine');
    return (existingAttr === '1' || existingAttr === 1 || existingData === 1 || existingData === '1');
  }

  function lockRow($row, lock, wasLocked) {
    var $qty    = $row.find('.input_quantity');
    var $btns   = $row.find('.quantity-down, .quantity-up');
    var $priceInc = $row.find('.pos_unit_price_inc_tax');
    var $priceEx  = $row.find('.pos_unit_price'); // direct sell only
    var $discAmt  = $row.find('.row_discount_amount');
    var $discType = $row.find('.row_discount_type');
    var $subIn    = $row.find('.pos_line_total');
    var $subText  = $row.find('.pos_line_total_text');
    var $reminder = $row.find('.lot-reminder');

    // flag when user edits qty (typing or +/- buttons)
    if (!$row.data('qtyUserSetBound')) {
      $row.on('input change', '.input_quantity', function(){ $qty.data('userSet', '1'); });
      $row.on('click', '.quantity-up, .quantity-down', function(){ $qty.data('userSet', '1'); });
      $row.data('qtyUserSetBound', true);
    }

    $row.toggleClass('lot-locked', !!lock);
    $reminder.toggle(!!lock);

    if (lock) {
      var existing = isExistingLine($row);
      // LOCK: disable edits; for existing lines keep the stored values visible.
      $qty.prop('disabled', true).attr('data-min','0');
      if (!existing && parseFloat($qty.val()||'0') !== 0) { $qty.val('0').trigger('change'); }
      $btns.prop('disabled', true);

      // money fields: show 0 only for new rows; keep originals for existing rows
      $priceInc.prop('readonly', true); if (!existing) setZeroMoney($priceInc);
      $priceEx.prop('readonly', true);  if (!existing) setZeroMoney($priceEx);
      $discAmt.prop('readonly', true);  if (!existing) setZeroMoney($discAmt);
      $discType.prop('disabled', true);
      if ($subIn.length) { if (!existing) { setZeroMoney($subIn); } }
      if (!existing) { textToZero($subText); }

      // For existing lines, re-apply saved values if anything was blanked elsewhere
      if (existing) {
        var origQty = $qty.attr('data-orig');
        if (origQty !== undefined && origQty !== null && origQty !== '') { $qty.val(origQty); }
        if ($priceInc.length && $priceInc.attr('data-orig')) { $priceInc.val($priceInc.attr('data-orig')); }
        if ($priceEx.length && $priceEx.attr('data-orig')) { $priceEx.val($priceEx.attr('data-orig')); }
        if ($discAmt.length && $discAmt.attr('data-orig')) { $discAmt.val($discAmt.attr('data-orig')); }
        if ($subIn.length && $subIn.attr('data-orig')) { $subIn.val($subIn.attr('data-orig')); }
        textToOrig($subText);
      }
      return;
    }

    // UNLOCK (lot selected)
    $qty.prop('disabled', false).attr('data-min','1');
    $btns.prop('disabled', false);
    $priceInc.prop('readonly', false);
    if ($priceEx.length){ $priceEx.prop('readonly', false); }
    $discAmt.prop('readonly', false);
    $discType.prop('disabled', false);
    if ($subIn.length) { $subIn.prop('readonly', false); }

    var firstUnlockDone = $row.data('firstUnlockDone') === '1';
    var userSet = $qty.data('userSet') === '1';

    // Only on the first transition from locked->unlocked decide a default qty
    if (wasLocked && !firstUnlockDone && !userSet) {
      var q = parseFloat($qty.val()||'0') || 0;
      if (q <= 0) { $qty.val('1').trigger('change'); }
      $row.data('firstUnlockDone', '1');
    }

    // restore originals ONLY on first unlock so we don't overwrite user edits later
    if (wasLocked && !firstUnlockDone) {
      setMoney($priceInc, $priceInc.attr('data-orig') || $priceInc.val());
      if ($priceEx.length){ setMoney($priceEx, $priceEx.attr('data-orig') || $priceEx.val()); }
      setMoney($discAmt,  $discAmt.attr('data-orig')  || $discAmt.val());
      if ($subIn.length) { setMoney($subIn, $subIn.attr('data-orig') || $subIn.val()); }
      textToOrig($subText);
    }

    // Final safeguard: for existing lines, always restore saved values after unlock
    if (isExistingLine($row)) {
      if ($qty.length && $qty.attr('data-orig')) { $qty.val($qty.attr('data-orig')); }
      if ($priceInc.length && $priceInc.attr('data-orig')) { $priceInc.val($priceInc.attr('data-orig')); }
      if ($priceEx.length && $priceEx.attr('data-orig')) { $priceEx.val($priceEx.attr('data-orig')); }
      if ($discAmt.length && $discAmt.attr('data-orig')) { $discAmt.val($discAmt.attr('data-orig')); }
      if ($subIn.length && $subIn.attr('data-orig')) { $subIn.val($subIn.attr('data-orig')); }
      textToOrig($subText);
    }
  }

  function hasRealLots($lot){ return $lot.find('option').length > 1; }

  function reevaluate($row) {
    var $lot = $row.find('select.lot_number');
    if (!$lot.length) return; // no lots for this product

    var wasLocked = $row.data('isLocked') === '1';
    // Existing saved lines should never be locked/zeroed; just ensure unlocked.
    if (isExistingLine($row)) {
      $row.data('isLocked', '0');
      lockRow($row, false, wasLocked);
      return;
    }
    if (!lotLockRequired($row)) {
      $row.data('isLocked', '0');
      lockRow($row, false, wasLocked);
      return;
    }

    var lock = hasRealLots($lot) && !$lot.val();
    $row.data('isLocked', lock ? '1' : '0');

    lockRow($row, lock, wasLocked);
  }

  // initial pass: evaluate existing rows
  $(function () {
    $('tr.product_row').each(function(){ reevaluate($(this)); });

    // Hard-restore saved values for existing lines (safety net if other scripts zero them)
    $('tr.product_row[data-existing-line="1"]').each(function () {
      var $row = $(this);
      // for qty, set without triggering change to avoid other handlers wiping it
      var $q = $row.find('.input_quantity');
      var saved = $q.attr('data-saved-qty');
      var oq = $q.attr('data-orig');
      var finalQty = (saved !== undefined && saved !== null && saved !== '') ? saved : oq;
      if (finalQty !== undefined && finalQty !== null && finalQty !== '') { $q.val(finalQty); }
      var $pic = $row.find('.pos_unit_price_inc_tax'); if ($pic.attr('data-orig')) { $pic.val($pic.attr('data-orig')); }
      var $pex = $row.find('.pos_unit_price'); if ($pex.attr('data-orig')) { $pex.val($pex.attr('data-orig')); }
      var $disc = $row.find('.row_discount_amount'); if ($disc.attr('data-orig')) { $disc.val($disc.attr('data-orig')); }
      var $sub = $row.find('.pos_line_total');
      var savedSub = $sub.attr('data-orig');
      if ($sub.length) {
        if (savedSub) {
          $sub.val(savedSub);
          $row.find('.pos_line_total_text').text(savedSub);
        } else if (finalQty && $pic.length) {
          var line = parseFloat(finalQty || 0) * __read_number($pic);
          $sub.val(line);
          $row.find('.pos_line_total_text').text(__currency_trans_from_en(line, true));
        }
      }
      textToOrig($row.find('.pos_line_total_text'));
    });
  });

  // when lot changes (native/select2), re-evaluate only that row
  $(document).on('change select2:select select2:clear', 'select.lot_number', function () {
    reevaluate($(this).closest('tr.product_row'));
  });

  // rows added later → evaluate only the new rows
  var obs = new MutationObserver(function (muts) {
    muts.forEach(function (m) {
      $(m.addedNodes).each(function () {
        var $n = $(this);
        if ($n.is && $n.is('tr.product_row')) { reevaluate($n); }
        if ($n.find) { $n.find('tr.product_row').each(function(){ reevaluate($(this)); }); }
      });
    });
  });
  obs.observe(document.body, { childList: true, subtree: true });
  window.BoonPOS_reEvaluateLotLocks = function () {
    $('tr.product_row').each(function(){ reevaluate($(this)); });
  };
})(jQuery);
</script>
